<!DOCTYPE html>
<!--
* PHP6 : motifCompteRendu.php
-->
<html>
<head>
    <meta charset="UTF-8" />
    <title>Détail du compte-rendu</title>
    <link rel="stylesheet" type="text/css" href="./css/detailCompteRendu.css" />
</head>
<body>
    <?php
    include_once("entete.php");
    include_once("modele/accesBDD.php");


    // Récupération de l'identifiant de l'utilisateur et du numéro de visite depuis l'URL
    if (isset($_GET["id"]) && isset($_GET["numVisite"])) {
        $idUtil = $_GET["id"];
        $vNum = $_GET["numVisite"];
    } else {
        // Gérer le cas où les valeurs ne sont pas présentes dans l'URL
        header("Location:affichageCompteRendu.php?msg=Paramètres manquants");
        exit();
    }


    // Récupération des informations de la visite à modifier
    $dbh = connexion();
    $laVisite = rechercherUneVisite($dbh, $idUtil,$vNum);

    $IdPraticien = isset($_POST["IdPraticien"]) ? $_POST["IdPraticien"] : $laVisite['IdPraticien'];
    $praticien = isset($_POST["praticienAdresse"]) ? $_POST["praticienAdresse"] : $laVisite['praticienAdresse'];
    $motif = isset($_POST["motifVisite"]) ? $_POST["motifVisite"] : $laVisite['vMotifLibelle'];
    $selectedMotif = isset($_POST["motifVisite"]) ? $_POST["motifVisite"] : $laVisite['vMotif'];
    if (isset($_POST["motifVisite"])) {
        $selectedMotif = $_POST["motifVisite"];
    }    
    $dateVisite = isset($_POST["vDate"]) ? $_POST["vDate"] : $laVisite['vDate'];
    $dateCR = isset($_POST["CRDate"]) ? $_POST["CRDate"] : $laVisite['CRDate'];
    $dateCRMaj = isset($_POST["CRDateMaj"]) ? $_POST["CRDateMaj"] : $laVisite['CRDateMaj'];
    $remarque = isset($_POST["remarque"]) ? $_POST["remarque"] : $laVisite['vRapport'];
    $confiance = isset($_POST["confiance"]) ? $_POST["confiance"] : $laVisite['vCoefConfiance'];
    $medic1 = isset($_POST["vMedicament1"]) ? $_POST["vMedicament1"] : $laVisite['vMedicament1'];
    $medic2 = isset($_POST["vMedicament2"]) ? $_POST["vMedicament2"] : $laVisite['vMedicament2'];
    $fam1 = isset($_POST["vFamille1"]) ? $_POST["vFamille1"] : $laVisite['vFamille1'];
    $fam2 = isset($_POST["vFamille2"]) ? $_POST["vFamille2"] : $laVisite['vFamille2'];

    if($fam2=='')
    {
        $fam2='Aucun';
    }
    ?>

    <div id="titre">
        <h2>Détail du compte-rendu</h2>
    </div>

    <form action="motifCompteRendu.php" method="get">

        <div id='InformationsNonModifiables'>
            <h3>Informations actuelles :</h3>
            <br>
            <div class='praticienCss'>
                <p>Praticien : <?php echo $praticien; ?></p>
            </div>

            <div class='visiteCss'>
                <div class='dateVisiteCss'>
                    <p>Date de visite : <?php echo $dateVisite; ?></p>
                </div>
                <div class='motifCss'>
                    <p>Motif : <?php echo $motif; ?></p>
                </div>
                <div class='confianceCss'>
                    <p>Confiance actuel : <?php for ($i=0; $i < $confiance; $i++) { echo '★'; } ?></p>
                </div>
                
            </div>

            <div class='datesCss'>
                <p>Date du compte-rendu : <?php echo $dateCR; ?></p>
                <p>Date de mise à jour du compte-rendu : <?php echo $dateCRMaj; ?></p>
            </div>

            <div class='medocCss'>
                <p>Medoc 1 : <?php echo $medic1 . " (" . $fam1 . ") "; ?></p>
                <p>Medoc 2 : <?php echo $medic2 . " (" . $fam2 . ") "; ?></p>
            </div>
            
            <div class='remarqueCSS'>
                <p>Remarque : <?php echo $remarque; ?></p>
            </div>

                <p>Échantillons : </p>
                <?php
                    $resultats = AfficheEchantillon($dbh, $idUtil, $vNum);

                    // Affichage des résultats dans un tableau HTML
                    echo "<table>";
                    echo "<tr><th>Famille</th><th>Echantillon</th><th>Nombre</th></tr>";

                    foreach ($resultats as $row) {
                        echo "<tr>";
                        echo "<td>" . $row['mNomCommercial'] . "</td>";
                        echo "<td>" . $row['fLibelle'] . "</td>";
                        echo "<td>" . $row['OFF_QTE'] . "</td>";
                        echo "</tr>";
                    }

                    echo "</table>";
                ?>

        </div>


        <div class='boutonDiv'>
            <p>
                <?php echo "<a href='motifCompteRendu.php?id=$idUtil&numVisite=$vNum' id='modifier'>Modifier</a>";?>
                <?php echo "<a href='#'id='supprimer' class='btn-retour')>Supprimer</a>" ?>
                <input type="button" onclick="location.href='affichageCompteRendu.php'; unsetSelectedVisit();" value="Retour" class="btn-retour">
            </p> 
        </div>
        
    </form>


    <div id="informationModifies-message">
        <?php
        // Q6-Affichage message d'erreur s'il existe
        if (isset($_GET["msg"])) 
        {
            $msg = $_GET["msg"];
            echo "<p>$msg</p>";
        }
        ?>
    </div>



<div id="confirmation" style="display: none;">
        <p>Êtes-vous sûr de vouloir supprimer ce compte-rendu ?</p>
    <div class='decallage'>
        <button id="confirmer">Oui</button>
        <button id="annuler">Non</button>
    </div>
</div>



<script>
    document.getElementById("supprimer").onclick = function() {
        document.getElementById("confirmation").style.display = "block";
        return false;
    };
    document.getElementById("confirmer").onclick = function() {
        window.location.href = "suppressCompteRendu.php?id=<?php echo $idUtil; ?>&numVisite=<?php echo $vNum; ?>";
    };
    document.getElementById("annuler").onclick = function() {
        document.getElementById("confirmation").style.display = "none";
    };
</script>



</body>
</html>
